<!DOCTYPE HTML>
<html><head><title>Formular mit html, css, javascript und php</title>
	<meta charset="UTF-8">
	<!--
		Einfaches HTML/CSS Formular von www.htmlkurs.ch
		*** Vorsicht: E-Mail Adressen ab Zeile 108 anpassen! ***
		Nach Submit
		- JavaScript checked die Mussfelder und das E-Mail Format
		- PHP liest alle Felder aus und mailed sie an $receiver
	-> 

<!-- CSS *** START -->
<style type="text/css">
body {
	color: #606060; background-color: #e0e0e0;
	font-family: Verdana; font-size: 1em;
	margin:20px 50px;
}

td {
	vertical-align: top;
	padding: 10px 10px 0px 0px;
}

form {
  	background-color: #d0e020; border: thin solid #ab0;
  	margin: 0; padding: 1em;
	width: 600px;
}

input, textarea, select {
	border: none;
	background: #f0f0f0;
	width: 300px;
	padding: 5px;
}

input[type="radio"] {
	width:auto; 
	float:none; 
	display:inline-block; 
	margin: 0px 5px 0px 0px; 
	padding: 0px;
}

.button {
	width: 120px;
	margin: 0px 10px 0px 10px;
	color: #ffffff;
	background-color: #000000;
}
</style>
<!-- CSS *** ENDE -->

<!-- JavaScript *** START -->
<script>
function pruefeformular ( kontakt )
{
// ** einfache E-Mail validierung > a@a ist gültig
var re = /.+@.+/;

  // ** START **
  if (kontakt.Nachname.value == "") {
    alert( "Bitte Name eingeben." );
    kontakt.Nachname.focus();
    return false ;
  }
  if (kontakt.Email.value == "" || !re.test(kontakt.Email.value)) {
    alert( "Bitte gültige E-Mail Adresse eingeben." );
    kontakt.Email.focus();
    return false ;
  }
  // ** END **
  return true ;
}
</script>
<!-- JavaScript *** Ende -->

</head>
<body>
<h1>Kontakt</h1>

<?php 
// Funktion zur Bereinigung der Eingabefelder
function test_input($data) {
  $data = trim($data);
  $data = stripslashes($data);
  $data = htmlspecialchars($data);
  return $data;
}
// Wurde Formular "submitted"? > verarbeite Formular
if ($_SERVER["REQUEST_METHOD"] == "POST") {
  // Formulardaten werden in einer HTML Tabelle dargestellt
  $formdata="<html><body><h1>Formulardaten</h1><table>";
  // Jedes Formularfeld-Paar wird als Name und Inhalt ausgegeben
  foreach($_POST as $key=>$value) {
  	$formdata = $formdata . "<tr><td>" . $key . "</td><td><b>" . test_input($value) ."</b></td></tr>";
  }
  $formdata = $formdata . "</table></body></html>";
  // Remote_Adresse auslesen
  $remoteIP = $_SERVER['REMOTE_ADDR'];
  if (strstr($remoteIP, ', ')) {
  	$ips = explode(', ', $remoteIP);
    $remoteIP = $ips[0];
  }
  $ip = gethostbyaddr($remoteIP); 
  $datum = date("l, d. F Y, G:i");  
  // *** Start: HIER Daten anpassen! ***
  $receiver = "cascara.gmbh@gmail.com";
  $sender = "info@supersache.ch";
  // *** Ende: Daten anpassen! ***
  // *** Start: Mail zusammenstellen ***
  $headers  = "From: $sender\r\n";
  $headers .= "Content-type: text/html; charset=UTF-8" . "\r\n";
  $subject = "Kontaktformular - ". $_SERVER['SERVER_NAME'];
  $body = $formdata . "<br />*********************************<br/>" . $datum . "<br/>" . $ip;
  // *** Ende: Mail zusammenstellen ***
  // Ist der E-Mail Versand erfolgreich?
 	if (@mail($receiver, $subject, $body, $headers)){
 		// alles geklappt - Schlussmeldung an User 
    	echo "<p>Besten Dank!</p>";
   	}
    else 
    {
    	// Mailversand ist auf dem Server nicht möglich
     	echo "<p class='error'>Fehler. Mail Versand war nicht erfolgreich.</p>";
		print_r(error_get_last());
		echo "<p><a href=".$_SERVER["PHP_SELF"].">&rarr; Zurück zum Formular</a></p>";
    }
 }
else {
// Submit wurde nicht geklickt-> Zeige Formular für die Eingabe
?>

<!-- Formular *** START -->
<form name="kontakt" method="POST" action="<?=$_SERVER["PHP_SELF"]?>" onsubmit="return pruefeformular(this);">
<p>Die mit einem Stern (*) gekennzeichneten Felder sind obligatorisch</p>
<table summary="" border="0">
  <tr>
    <td>Anrede</td>
    <td><input type="text" name="Anrede" size="20" /></td>
  </tr>
  <tr>
    <td>Name *</td>
    <td><input type="text" name="Nachname" size="20" /></td>
  </tr>
  <tr>
    <td>Vorname *</td>
    <td><input type="text" name="Vorname" size="20" /></td>
  </tr>
  <tr>
    <td>E-Mail *</td>
    <td><input type="text" name="Email" size="20" /></td>
  </tr>
  <tr>
    <td>Telefon</td>
    <td><input type="text" name="Telefon" size="20" /></td>
  </tr>
  <tr>
    <td>Geschlecht</td>
    <td>
    	<input type="radio" name="Geschlecht" value="m">männlich<br>
    	<input type="radio" name="Geschlecht" value="w">weiblich<br>
    	<input type="radio" name="Geschlecht" value="n/a" checked>keine Angabe
    </td>
  </tr>
  <tr>
    <td>Land</td>
    <td>
		<select id="land" name="Land">
			<option value="n/a">-</option>
			<option value="ch">Schweiz</option>
			<option value="d">Deutschland</option>
			<option value="a">Österreich</option>
		</select>
    </td>
  </tr>
  <tr>
    <td>Kommentar</td>
    <td><textarea cols="20" rows="7" name="Kommentar"  size="10"></textarea></td>
  </tr>
  <tr>
    <td></td>
    <td><input class="button" type="submit" name="submit" value="Absenden">  <input class="button" type="reset" name="reset" value="L&ouml;schen"></td>
  </tr>
</table>
</form>
<!-- Formular *** ENDE -->
<?php 
} 
?>
</body></html>